#----------------------------------------------------------------------
#  Script prova lettura file GCODE (Marlin) con Julia (preallocated)
#  Autore: Andrea Pavan
#  Data: 10/10/2022
#----------------------------------------------------------------------
@time function lettura_gcode(filename::String)

#lettura file GCODE
gcode = readlines(filename);
N = length(gcode);
M = zeros(Float32,N+1,4);       #matrice Nx4 contenente colonne [X,Y,Z,F]

#parsing
newPosition = zeros(Float32,3);
newFeedrate = 0f0;
i = 1;
for line in gcode
    if line[1:2] == "G0" || line[1:2] == "G1"
        line_params = split(split(line,';')[1], ' ', keepempty=false);
        for line_param in line_params
            if line_param[1] == 'X'
                newPosition[1] = parse(Float32,line_param[2:end]);
            elseif line_param[1] == 'Y'
                newPosition[2] = parse(Float32,line_param[2:end]);
            elseif line_param[1] == 'Z'
                newPosition[3] = parse(Float32,line_param[2:end]);
            elseif line_param[1] == 'F'
                newFeedrate = parse(Float32,line_param[2:end]);
            end
        end
        i += 1;
        M[i,1:3] = newPosition';
        M[i,4] = newFeedrate;
        #path = vcat(path,newPosition');
        #feedrate = vcat(feedrate,newFeedrate);
    #else
        #println(line);
    end
end
return M[1:i,:];
end


M = lettura_gcode("esempio_gcode.gcode");
